"use strict";
this.name		= "murphy-thargoid-drive.js";
this.author		= "Capt. Murphy";
this.copyright	= "2012 - inspired by work by Switeck, Okti, and Mauiby de Fug";
this.license		= "CC BY-NC-SA 3.0"; // see http://creativecommons.org/licenses/by-nc-sa/3.0/ for more info. Feel free to adapt any of this code for your own use.
this.credits		= "Inspired by similar work by Mauiby de Fug, Okti and Switeck. A big thank-you to Switeck in particular for getting me interested in this concept, exhaustive testing, and for his constructive comments and discussion. Model for Scoopable Thargoid Witchspace Drive courtesy of Thargoid. Also thanks to Okti, Eric Walch and Micha for testing prototype."
this.description= "Worldscript for Thargoid Witchspace Drive.";
this.version	= "0.9.6";
// Hacked up by Switeck to add extra capabilities...

"use strict";

// OXPConfig2 attributes
this.oxpcSettings = {
	Info: {Name:"murphy-thargoid-drive.js",Display:"Thargoid Witchspace Drive",Notify:true,InfoB:"Please see OXP spoilers.rtf for an explanation of settings."},
	Bool0: {Name:"dynamicTAF",Def:true,Desc:"Dynamic TAF."},
	Bool1: {Name:"updateRouteMidChain",Def:true,Desc:"Dynamic Route Updating."},
	Bool2: {Name:"updateRouteModBool",Def:true,Desc:"Quicker transit times."},
	Bool3: {Name:"loggingEnabled",Def:false,Desc:"Enable Log Messages."}
	}
	
this.oxpcNotifyOnChange = function(what)
{
 if(!this.updateRouteModBool){this.updateRouteModifier = 0.667;return;}// results in travel times roughly equivalent to an "OPTIMIZE_BY_DISTANCE" route of standard jumps.
 this.updateRouteModifier = 0.999;// results in travel times roughly equivalent to an "OPTIMIZE_BY_TIME" route of standard jumps. Can be quicker on some routes.
}

// these variables are the defaults for those that can modified via OXPConfig if installed.
this.updateRouteMidChain = true; //will dynamically update jump routes to improve travel time (in game hours)
this.updateRouteModifier = 0.999; // default for fastest in game hours travel times.
this.updateRouteModBool = true; // used by OXPconfig.
this.dynamicTAF = true; // varies TAF during jumps to improve user experience of travel times.
this.loggingEnabled = false; // if true enables log commands in script

// not included in OXPConfig settings.	
this.disableEquipment = false; // flag for use by other OXPs scripts to temporarily disable Thargoid Witch Space Drive. If true attempting to activate the drive will fail. Accessed via worldScripts["murphy-thargoid-drive.js"].disableEquipment
this.method = "OPTIMIZED_BY_TIME"; // method used by route finder to calculate quickest route - do not change.
this.cheat = false; // if true player is awarded a fully functional Thargoid Witchspace Drive with the 'best' parameters at startUp. If the game is saved it will be removed again on reloading the save game, and replaced by some Trumbles.... ;-) 
this.test = false; // if true player will always encounter an scoopable Thargoid Witchspace Drive pod when killing a Thargoid in Interstellar space, irrespective of the player.score.

// default attributes for drive - if edited here must also edit this.setVariables = function()
this.driveCounter = 0; // a persistent count of how many drives the player has fitted.
this.powerRequirement = 0.9; // default power requirement of the drive
this.detectChance = 0.2; // default chance of detection by police in high tech (12 and above systems). Also chance of thargoid presence on arrival at destination.
this.damageChance = 0.4; // default chance of equipment damage at end of jumpchain and of drive destruction if damaged.
this.disableNormalSpaceStart = true; // prevents drive activation in normal space.

this.startUp = function()
{
	if(missionVariables.murphy_thargoid_drive_driveCounter) this.driveCounter = missionVariables.murphy_thargoid_drive_driveCounter;
	if(player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") === "EQUIPMENT_OK" && this.driveCounter < 5) { // legit installed drive.
		this.setVariables();
		return;
	}
	if(this.driveCounter === 5) { // drive installed by cheat mode
		player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE");
		player.ship.awardEquipment("EQ_TRUMBLE");
		this.cheat = false;
		this.driveCounter = 0;
		if(this.loggingEnabled) log(this.name,"Thargoid Witchspace Drive previously awarded in cheat mode removed, and replaced with a special gift.");
	}
	if(this.cheat) { // install drive in cheat mode.
		player.ship.awardEquipment("EQ_MURPH_THARGOID_DRIVE");
		this.driveCounter = 5;
		this.setVariables();
		if(this.loggingEnabled) log(this.name,"Thargoid Witchspace Drive awarded in cheat mode.");
	}
}	

this.playerWillSaveGame = function()
{
	missionVariables.murphy_thargoid_drive_driveCounter = this.driveCounter;
}

this.equipmentDamaged = function(equipment)
{
	if(equipment === "EQ_MURPH_THARGOID_DRIVE" && Math.random() < this.damageChance) {
		player.consoleMessage("Thargoid Witchspace Drive Destroyed!",6);
		player.ship.removeEquipment(equipment);
		player.ship.energy -= player.ship.energy*Math.random();
		return;
	}
	if(equipment === "EQ_MURPH_THARGOID_DRIVE_TOFIT" || equipment === "EQ_MURPH_THARGOID_DRIVE") player.ship.setEquipmentStatus(equipment,"EQUIPMENT_OK");
}

this.playerBoughtEquipment = function(equipment)
{
	if(equipment === "EQ_MURPH_THARGOID_DRIVE_QUOTE") {
	this.showScreen = true;
	this.missionScreenOpportunity();
	}
}

this.setVariables = function()
{
	switch (this.driveCounter) {
		case 0:
		break;
		case 1:
		this.powerRequirement = 0.9;
		this.detectChance = 0.2;
		this.damageChance = 0.4;
		this.disableNormalSpaceStart = true;
		break;
		case 2:
		this.powerRequirement = 0.6;
		this.detectChance = 0.1;
		this.damageChance = 0.2;
		this.disableNormalSpaceStart = true;
		break;
		case 3:
		this.powerRequirement = 0.3;
		this.detectChance = 0.05;
		this.damageChance = 0.1;
		this.disableNormalSpaceStart = true;
		break;
		default:
		this.powerRequirement = 0.1;
		this.detectChance = 0.025;
		this.damageChance = 0.05;
		this.disableNormalSpaceStart = false;
	}
}

this.missionScreenOpportunity = function()
{
	if(!this.showScreen) return;
	delete this.showScreen;
	switch (this.driveCounter) {
		case 0:
		this.fittingCost = 10000;
		mission.runScreen({title:"Thargoid Witchspace Drive Fitting", messageKey:"murphy-thargoid-drive1", model:"murphy_thargoid_drive_pod", choicesKey:"murphy_thargoid_drive_choices1"}, this.choice);
		break;
		case 1:
		this.fittingCost = 20000;
		mission.runScreen({title:"Thargoid Witchspace Drive Fitting", messageKey:"murphy-thargoid-drive2", model:"murphy_thargoid_drive_pod", choicesKey:"murphy_thargoid_drive_choices1"}, this.choice);
		break;
		case 2:
		this.fittingCost = 40000;
		mission.runScreen({title:"Thargoid Witchspace Drive Fitting", messageKey:"murphy-thargoid-drive3", model:"murphy_thargoid_drive_pod", choicesKey:"murphy_thargoid_drive_choices1"}, this.choice);
		break;
		default:
		this.fittingCost = 80000;
		mission.runScreen({title:"Thargoid Witchspace Drive Fitting", messageKey:"murphy-thargoid-drive4", model:"murphy_thargoid_drive_pod", choicesKey:"murphy_thargoid_drive_choices1"}, this.choice);
	}
}

this.choice = function(choice)
{
	if(choice === "1_YES") {
		if(player.credits < this.fittingCost) {
			player.consoleMessage("Not enough credits to purchase fitting of Thargoid Witchspace Drive.",10);
			player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_QUOTE");
			return;
		}
		player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_QUOTE");
		player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_TOFIT");
		player.ship.awardEquipment("EQ_MURPH_THARGOID_DRIVE");
		player.credits -= this.fittingCost;
		clock.addSeconds(216000+(this.fittingCost*10)); // emulates source code calculation for time adjustment.
		player.consoleMessage("Thargoid Witchspace Drive fitted. Press shift-N followed by N to activate.",10);
		this.driveCounter++;
		if(this.driveCounter > 4) this.driveCounter = 4;
		this.setVariables();
		return;
	}
	player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_QUOTE");
	player.consoleMessage("Thargoid Witchspace Drive not fitted. Remains in manifest(N/A).",10);
}

this.shipKilledOther = function(target,how)
{
	if(!system.isInterstellarSpace || target.roles.indexOf("thargoid") === -1 || player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") === "EQUIPMENT_OK" || player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE_TOFIT") === "EQUIPMENT_OK" || (this.drivePod && this.drivePod.isValid)) return;
	var chance;
	if(player.score < 6400){chance = player.score/25600;} else chance = 0.25;
	if(Math.random() < chance || this.test) {
		this.drivePod = system.addShips("murphy_thargoid_drive_pod",1,target.position,25)[0];
		this.drivePod.scannerDisplayColor1 = "orangeColor"; this.drivePod.scannerDisplayColor2 = "greenColor";
		player.consoleMessage("Unusual radiation source detected. Cannot identify.",10);
		if(this.drivePodTimer && this.drivePodTimer.isRunning){this.drivePodTimer.stop();delete this.drivePodTimer;}
		this.drivePodTimer = new Timer(this,this.explodeDrivePod,(60 + Math.ceil(Math.random()*120)));
	}
}

this.explodeDrivePod = function(){if(this.drivePod && this.drivePod.isValid)this.drivePod.explode();}

this.shipScoopedOther = function(whom)
{
	if(whom.primaryRole === "murphy_thargoid_drive_pod") {
		player.ship.awardEquipment("EQ_MURPH_THARGOID_DRIVE_TOFIT");
		player.consoleMessage("Scooped unusual Thargoid technology. Scanning. Check Status Screen (F5).",6);
	}
}

this.shipWillDockWithStation = function(station)
{
	if(this.policeScanTimer && this.policeScanTimer.isRunning){this.policeScanTimer.stop();delete this.policeScanTimer;}
	if((player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE_TOFIT") === "EQUIPMENT_OK") && system.government === 0 && system.techLevel >6) missionVariables.murphy_thargoid_drive_equipmentAvailable = "true"
	else if((player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") === "EQUIPMENT_OK") && station.isMainStation && this.detected) {
		player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE");
		player.bounty += 100;
		player.consoleMessage("Galcop customs have detected Illegal Thargoid Drive Technology on your ship. Ship raided by customs and Thargoid Witchspace Drive impounded. Legal penalty applied.",10);
	}
	delete this.detected;
}

this.shipLaunchedFromStation = function(station)
{
	if(this.policeScanTimer && this.policeScanTimer.isRunning){this.policeScanTimer.stop();delete this.policeScanTimer;}
	delete missionVariables.murphy_thargoid_drive_equipmentAvailable;
	if(player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE_QUOTE") === "EQUIPMENT_OK") player.ship.removeEquipment("EQ_MURPH_THARGOID_DRIVE_QUOTE");
	if(player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") === "EQUIPMENT_OK" && (Math.random() < (this.detectChance + ((system.government + system.techLevel - 16)/100)))) {this.policeScanTimer = new Timer(this, this.scanForThargoidDrive,30,30); if(this.loggingEnabled){log(this.name,"Police scanner Timer initialised.");}}
}

this.shipDied = function()
{if(this.policeScanTimer && this.policeScanTimer.isRunning){this.policeScanTimer.stop();delete this.policeScanTimer;}}

this.scanForThargoidDrive = function()
{
	if(player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") !== "EQUIPMENT_OK"){this.policeScanTimer.stop();delete this.policeScanTimer;return;}
	var police;
	var counter;
	police = system.shipsWithPrimaryRole("police",player.ship,player.ship.scannerRange);
	if(police.length > 0) {
		var arrayLength = police.length;
		for (counter = 0; counter < arrayLength;counter++) {
			if(!police[counter].target && Math.random() < 0.5) {
				player.bounty+=250;
				police[counter].target = player.ship;
				police[counter].switchAI("policeInterceptAI.plist");
				police[counter].commsMessage("Thargoid drive signature detected. It's gotta be some sort of decoy - shoot to kill.",player.ship);
				this.detected = true;
				this.policeScanTimer.stop();
				delete this.policeScanTimer;
				break;
			}
		}
	}
}

this.shipExitedWitchspace = function()
{
	if(this.policeScanTimer && this.policeScanTimer.isRunning){this.policeScanTimer.stop();delete this.policeScanTimer;}
	if(!system.isInterstellarSpace && player.ship.equipmentStatus("EQ_MURPH_THARGOID_DRIVE") === "EQUIPMENT_OK" && (Math.random() < (this.detectChance + ((system.government + system.techLevel - 16)/100)))) {this.policeScanTimer = new Timer(this, this.scanForThargoidDrive,30,30); if(this.loggingEnabled){log(this.name,"Police scanner Timer initialised.");}}
	if(this.jumping){delete this.playerJumpSuccess; this.jumpFunction(); return;} // if part way through jump chain continue.
}

// if part way through jump chain set playerJumpSuccess flag on wormhole entry, and increase TAF to 16 for jump.
this.shipWillEnterWitchspace = function(type)
{if(type === "wormhole" && this.jumping) {this.playerJumpSuccess = true; this.misjumpCounter++; player.ship.energy = (player.ship.maxEnergy - (player.ship.maxEnergy * this.powerRequirement)); if(this.dynamicTAF) timeAccelerationFactor = 16;}}

// called from equipmentScript to start jump chain
this.initialJump = function()
{
 if(this.loggingEnabled) log(this.name,"this.initialJump called from equipment script.");
 if(this.disableEquipment) {
	if(this.loggingEnabled) log(this.name,"Equipment disabled as this.disableEquipment flag set by other OXP.");
	player.consoleMessage("Could not activate Thargoid Witchspace Drive - malfunction - unknown cause!",6);
	return;
 }
 if(this.jumping) { // if activated during existing jump chain will abort existing jump chain
	this.abortJump = true;
	if(this.loggingEnabled) log(this.name,"this.initialJump called during jump chain - will abort jump chain.");
	player.consoleMessage("Thargoid Witchspace Drive deactivated - jump chain aborting!",6);
	return;
 }
 if(!system.isInterstellarSpace && this.disableNormalSpaceStart) {player.consoleMessage("Thargoid Witchspace Drive blocked by local star's gravity well. This equipment can only be activated in Interstellar space.",6); return;} // optionally disable starting the equipment in normal space
 if(system.ID === player.ship.targetSystem) { // warn player and abort jump if targetSystem is same as system.ID.
	if(this.loggingEnabled) log(this.name,"No target system set. Aborting jump.");
	player.consoleMessage("Please select a target system on the Long Range Chart before activating Thargoid Witchspace Drive.",6);
	return;
 }
 if(player.ship.energy < player.ship.maxEnergy * this.powerRequirement) {
	if(this.loggingEnabled) log(this.name,"Not enough energy to initialise jump.");
	player.consoleMessage("Energy too low to activate Thargoid Witchspace Drive.",6);
	return;
 }
 if(this.timeCheckTimer && this.timeCheckTimer.isRunning) {
	this.timeCheckTimer.stop();
	delete this.timeCheckTimer;
	delete this.expectedTime;
	delete this.startTime;
	if(this.loggingEnabled) log(this.name,"Time check timer not completed prior to initialising new jump. Timer stopped and variables cleared.");
 }
 if(this.dynamicTAF) timeAccelerationFactor = 1;
 delete this.jumpArray; // delete jumpArray from previous use
 this.targetSystem = player.ship.targetSystem; // get target system 
 this.getRoute(); // call function to calculate initial jump chain.
 if(!this.jumpArray) { // if no valid route end function.
	if(this.loggingEnabled) log(this.name,"No valid route from system:"+ system.ID+" to system:"+player.ship.targetSystem);
	player.consoleMessage("No valid route to target system.",6);
	return;
 }
	this.jumping = true; // flag used to note that player is in jump chain
	if(this.loggingEnabled) log(this.name,"this.jumpArray: "+this.jumpArray+" ,this.jumpArray.length: "+this.jumpArray.length);
	this.misjumpCounter = 0; // counter for actual number of jumps utilised.
	this.shortenChain = 0;
	this.repeatTolerance = 13;
	this.jumpFunction(true); // start jumpFunction with parameter true as first jump in chain.
}

this.getRoute = function()
{
	var sysInRange = SystemInfo.systemsInRange(7); // get array of systems in range of a jump
	if(sysInRange.length > 0) {
	var arrayLength = sysInRange.length;
	var counter;
	var sysInRangeID = new Array(sysInRange.length)
	for (counter = 0; counter < arrayLength;counter++) sysInRangeID[counter] = sysInRange[counter].systemID;	// make an array of systems IDs in range.
	if(this.loggingEnabled) log(this.name,"Calculate route first stage. Systems in range: "+sysInRangeID);
	var timeFromSys = new Array(sysInRangeID.length);
	var distance;
	var routeTime;
	for (counter = 0; counter < arrayLength;counter++) // make an array of the jump times from those systems to the target with a modifier for a misjump in the direction of that system.
	{
	if(System.infoForSystem(galaxyNumber,sysInRangeID[counter]).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method)) {
		distance = System.infoForSystem(galaxyNumber,system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,sysInRangeID[counter]));
		routeTime = System.infoForSystem(galaxyNumber,sysInRangeID[counter]).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).time + (distance*distance*this.updateRouteModifier);
		timeFromSys[counter] = Number(routeTime.toFixed(2));
	} else timeFromSys[counter] = 9999;
	}
	if(this.loggingEnabled) log(this.name,"Calculated jump chain travel times from nearby systems: "+timeFromSys);
	var firstjumpSysTime = timeFromSys[0];
	var firstjumpSysID = sysInRangeID[0];
	for (counter = 0; counter < arrayLength;counter++)// chose system with shortest travel time to target
	{
	if(timeFromSys[counter] <= firstjumpSysTime){firstjumpSysTime = timeFromSys[counter];firstjumpSysID = sysInRangeID[counter];}
	if(this.loggingEnabled) log(this.name,"timeFromSys[counter]:" + timeFromSys[counter] + " sysInRangeID[counter]:" + sysInRangeID[counter] + " firstjumpSysTime:" + firstjumpSysTime + " firstjumpSysID:" + firstjumpSysID);
	}
	if(firstjumpSysTime !== 9999) { // means that there was no valid route to target system.
	if(!this.expectedTime) { // set expected time of arrival if route was normal jumps.
		if(!system.isInterstellarSpace){this.expectedTime = System.infoForSystem(galaxyNumber,system.ID).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).time;}
		else this.expectedTime = firstjumpSysTime;
		this.startTime = clock.seconds;
	}
	if(this.jumpArray) { // if updating route mid chain do some checks...
		if(this.loggingEnabled) log(this.name,"jumpArray[jumpCounter]: "+ this.jumpArray[this.jumpCounter] + " alternative: "+ firstjumpSysID);
		if(this.jumpArray[this.jumpCounter] === firstjumpSysID) {this.shortenChain = 0;if(this.loggingEnabled){log (this.name,"Retaining current jump chain, no better option.");}return;}// don't update if already on best route
		if(this.jumpArray[this.jumpCounter - 1] === firstjumpSysID){this.shortenChain++; if(this.shortenChain > this.repeatTolerance){this.shortenChain = 0;if(this.loggingEnabled){log (this.name,"Retaining current jump chain - have recalculated to same target more than "+(this.repeatTolerance+1)+" times.");}if(this.repeatTolerance > 7){this.repeatTolerance--}return;}} // shorten some very long jump chains by setting limit on repeated misjump to same system
		if((System.infoForSystem(galaxyNumber,firstjumpSysID).distanceToSystem(System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter])))=== 0 || ((this.jumpArray[this.jumpCounter-1] !== firstjumpSysID) && (System.infoForSystem(galaxyNumber,firstjumpSysID).distanceToSystem(System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter-1])) === 0))) {this.shortenChain = 0;if(this.loggingEnabled){log (this.name,"Retaining current jump chain, avoiding 0 distance pair loop.");}return;}//avoids loops if route includes a 0 distance pair.
		if((this.jumpCounter-2) !==0 && this.jumpArray[this.jumpCounter-2] === firstjumpSysID){this.shortenChain = 0;if(this.loggingEnabled){log (this.name,"Retaining current jump chain, avoiding loop.");}return;} // avoids rare loop.
		distance = System.infoForSystem(galaxyNumber,system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter]));
		if(distance <= 7) {
			routeTime = Number((System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter]).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).time + (distance*distance*this.updateRouteModifier)).toFixed(2));
			if(routeTime <= firstjumpSysTime) {this.shortenChain = 0;if(this.loggingEnabled){log (this.name,"Retaining current jump chain. Current Route Time: "+routeTime+" Alternative Route Time: "+firstjumpSysTime);} return;} // don't update if already on best route
		}
		if(distance > 7) {
			distance = System.infoForSystem(galaxyNumber,system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter-1]));
			routeTime = Number((System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter-1]).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).time + (distance*distance*this.updateRouteModifier)).toFixed(2));
			if(routeTime <= firstjumpSysTime) {this.shortenChain = 0;if(this.loggingEnabled){log (this.name,"Retaining current jump chain. Current Route Time: "+routeTime+" Alternative Route Time: "+firstjumpSysTime);} return;} // don't update if already on best route
		}
	}
	this.firstjumpID = new Array;
	this.firstjumpID[0] = firstjumpSysID;
	this.jumpArray = System.infoForSystem(galaxyNumber,this.firstjumpID[0]).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route;
	} else this.unreachableSystem(sysInRangeID);
	if(!this.jumpArray) {
		if(this.loggingEnabled) log(this.name,"No valid route from system:"+ system.ID+" to system:"+player.ship.targetSystem);
		player.consoleMessage("No valid route to target system.",6);
		return;
	}
this.jumpArray = this.firstjumpID.concat(this.jumpArray);
this.jumpCounter = 1;
if(this.loggingEnabled) log(this.name,"Jump path calculated to: "+ this.jumpArray);
	}
}

// used for special cases - crossing Great Rift and getting to Oresrati.
this.unreachableSystem = function(sysInRangeID)
{
	if(this.loggingEnabled) log(this.name,"this.unreachableSystem called.");
	if(galaxyNumber < 6 || this.driveCounter <2) return;	// Unreachable systems now require a better-than-bare-minimum drive!
	var timeFromSys = new Array(sysInRangeID.length);
	var counter;
	var distance;
	var routeTime;
	var arrayLength = sysInRangeID.length;
	var firstStageDest;
	var timeFromSys = new Array(sysInRangeID.length)
	if(galaxyNumber ===6) { // first look at cases where player is already at a 'gateway' system for a great rift crossing.
	// Since only the best version of the drive will work starting at a regular system, no need to check for it!
	if(system.ID === 89 || system.ID === 194 || system.ID === 17 || system.ID === 178 || system.ID === 36 || system.ID === 46 || system.ID === 180 || system.ID === 192 || system.ID === 212) {
		this.unreachableJumpChain = true;
		if(!this.expectedTime) {this.expectedTime = "Route not possible by normal jumps."; this.startTime = clock.seconds;}
		this.firstjumpID = new Array;
		this.firstjumpID[0] = system.ID;
		switch (system.ID) {
		case 89:
		this.jumpArray = [194];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 194:
		this.jumpArray = [89];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 17:
		this.jumpArray = [178];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,192).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 178:
		this.jumpArray = [17];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,192).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 36:
		this.jumpArray = [212,212,180,192];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 46:
		this.jumpArray = [36,212,180,192];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 180:
		this.jumpArray = [36,212,180,192];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 192:
		this.jumpArray = [212,36,180,192];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		case 212:
		this.jumpArray = [36,212,180,192];
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route);
		break;
		}
		return;
	} // otherwise check which side of rift we are on and set a first stage destination as a gateway system
	if(System.infoForSystem(galaxyNumber,sysInRangeID[0]).routeToSystem(System.infoForSystem(galaxyNumber, 89),this.method)) {
		routeTime = System.infoForSystem(galaxyNumber,sysInRangeID[0]).routeToSystem(System.infoForSystem(galaxyNumber, 89),this.method).time;
		if(routeTime < System.infoForSystem(galaxyNumber,sysInRangeID[0]).routeToSystem(System.infoForSystem(galaxyNumber, 194),this.method).time) firstStageDest = 89
		else firstStageDest = 194;
		if(routeTime > System.infoForSystem(galaxyNumber,sysInRangeID[0]).routeToSystem(System.infoForSystem(galaxyNumber, 212),this.method).time && System.infoForSystem(galaxyNumber,sysInRangeID[0]).routeToSystem(System.infoForSystem(galaxyNumber, 194),this.method).time > System.infoForSystem(galaxyNumber,sysInRangeID[0]).routeToSystem(System.infoForSystem(galaxyNumber, 212),this.method).time && this.driveCounter > 3) firstStageDest = 212;
	} else firstStageDest = 17;
	} // next look at case of jump to Oresrati from gateway system
	if(galaxyNumber === 7 && this.targetSystem === 162 && (system.ID === 121 || system.ID === 9)) {
	this.firstjumpID = new Array;
	if(system.ID === 121) {
		this.firstjumpID[0] = 121;
		this.jumpArray =[9,88,118,88,162];
	} else {
		this.firstjumpID[0] = 9;
		this.jumpArray =[121,88,118,88,162];
	}
	this.unreachableJumpChain = true;
	if(!this.expectedTime) {this.expectedTime = "Route not possible by normal jumps."; this.startTime = clock.seconds;}
	return;
	} // otherwise set 121 as first stage destination
	if(galaxyNumber === 7 && this.targetSystem === 162) if(this.driveCounter > 2 && system.ID != 118 && system.ID != 137) firstStageDest = 9
		else firstStageDest = 121;
	// then go one to create jumpArray to appropriate gateway system, the misjump route, and remainder of route.
	for (counter = 0; counter < arrayLength;counter++) {
	if(System.infoForSystem(galaxyNumber,sysInRangeID[counter]).routeToSystem(System.infoForSystem(galaxyNumber, firstStageDest),this.method)) {
		distance = System.infoForSystem(galaxyNumber,system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,sysInRangeID[counter]));
		routeTime = System.infoForSystem(galaxyNumber,sysInRangeID[counter]).routeToSystem(System.infoForSystem(galaxyNumber, firstStageDest),this.method).time + (distance*distance*this.updateRouteModifier);
		timeFromSys[counter] = routeTime;
	} else timeFromSys[counter] = 9999;
	}
	if(this.loggingEnabled) log(this.name,"Calculated times from nearby systems: "+timeFromSys);
	var firstjumpSysTime = timeFromSys[0];
	var firstjumpSysID = sysInRangeID[0];
	for (counter = 1; counter < arrayLength;counter++) {
	if(timeFromSys[counter] < firstjumpSysTime){firstjumpSysTime = timeFromSys[counter];firstjumpSysID = sysInRangeID[counter];}
	}
	if(firstjumpSysTime !== 9999) {
	if(!this.expectedTime) {this.expectedTime = "Route not possible by normal jumps."; this.startTime = clock.seconds;}
	this.firstjumpID = new Array;
	this.firstjumpID[0] = firstjumpSysID;
	this.jumpArray = System.infoForSystem(galaxyNumber,this.firstjumpID[0]).routeToSystem(System.infoForSystem(galaxyNumber, firstStageDest),this.method).route;
	if(firstStageDest === 89) {
		this.jumpArray.push(89,89,89,194); //we want to misjump as close as possible to Maedreale and then misjump to Tiared
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route); // before misjumping across the rift to Articeso and following rest of route.
	} 
	if(firstStageDest === 194) {
		this.jumpArray.push(194,194,194,89); //we want to misjump as close as possible to Tiared and then misjump to Maedrale
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,229).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route); // before misjumping across the rift to Belera and following rest of route.
	}
	if(firstStageDest === 17) {
		this.jumpArray.push(17,17,17,178); //we want to misjump as close as possible to Esarxeve and then misjump to Xeona
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,192).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route); // before misjumping across the rift to Belera and following rest of route.
	}
	if(firstStageDest === 212) {
		this.jumpArray.push(212,212,36,212,180,192); //we want to misjump as close as possible to 212 and then misjump to 36
//		this.jumpArray.push(212,212,212,36,212,180,192); //we want to misjump as close as possible to 212 and then misjump to 36
		this.jumpArray = this.jumpArray.concat(System.infoForSystem(galaxyNumber,178).routeToSystem(System.infoForSystem(galaxyNumber, this.targetSystem),this.method).route); // before misjumping across the rift to Belera and following rest of route.
	}
	if(firstStageDest === 9) this.jumpArray.push(9,9,9,121,88,118,88,162); // add Oresrati misjump chain (thanks to Okti and onewayticket).
	if(firstStageDest === 121) this.jumpArray.push(121,121,121,9,88,118,88,162); // add Oresrati misjump chain (thanks to Okti and onewayticket).
	this.unreachableJumpChain = true;
	}
}

 this.jumpFunction = function(firstjump)
{
	if(this.loggingEnabled) log(this.name,"this.jumpFunction called with firstjump flag: " + firstjump);
	if(!firstjump && this.jumpEntity && this.jumpEntity.isValid) this.jumpEntity.remove(true); // removes jumpEntity from previous jump if present.
	if((this.jumpCounter >= this.jumpArray.length) || this.abortJump) { // check to see if last jump was final jump or if player has reactivated equipment part way through chain and if so end function
		if(this.loggingEnabled) log(this.name,"Jump ended: Total Misjumps: "+this.misjumpCounter);
		delete this.jumpArray;
		delete this.jumpCounter;
		delete this.jumping;
		delete this.unreachableJumpChain;
		delete this.misjumpCounter;
		if(this.dynamicTAF) timeAccelerationFactor = 1;
		if(this.expectedTime) this.timeCheckTimer = new Timer(this,this.timeCheck,0.25,0.25);
		delete this.abortJump;
		if(Math.random() < this.detectChance*2) system.addGroup("thargoid",Math.ceil(Math.random()*20),player.ship,15000);
		if(Math.random() < this.damageChance) {
			var equipment = player.ship.equipment;
			var index = Math.floor(Math.random()*equipment.length);
			player.ship.setEquipmentStatus(equipment[index],"EQUIPMENT_DAMAGED");
			player.consoleMessage(equipment[index].name+ " damaged in transit!",6);
		} else {player.ship.awardEquipment("EQ_RENOVATION"); player.ship.removeEquipment("EQ_RENOVATION");}	// This line is bizarre!	Does it instantly repair the ship?
		player.ship.energy = (player.ship.maxEnergy - (player.ship.maxEnergy * this.powerRequirement));
		return;
	}
	this.removeEntities(); // calls function to remove potentially mass-locking entities
	if(!firstjump) { // if part way through jump chain set timer for next jump
	if(!this.unreachableJumpChain && this.updateRouteMidChain) this.getRoute(); // call function to update route
	this.jumpTimer = new Timer(this, this.startnextJump,0.25,0.25);
	return;
	}
	// otherwise carry on for first jump
	delete this.averageDelta; // delete this.averageDelta - this variable is a measure of framerate - will be 1 if 100fps, 2 if 50fps, 4 if 25fps
	this.jumpFailed = 1; // set jumpFailed flag to 1, used to modify spawn distance and velocity boost.
	this.deltaArray = new Array;
	this.frameRateCheckCallback = addFrameCallback(this.callbackFunction.bind(this)); //sets up frameCallback to check framerate before starting next jump
}

this.callbackFunction = function(delta) // delta is the time since the last frame
{
 if(this.deltaArray && this.deltaArray.length < 10) { // create an array of delta for the last 10 frames
	if(delta > 0) this.deltaArray.push(delta);
	return;
 }
 var counter;
 var arrayLength = this.deltaArray.length;
 var deltaSum = 0;
 for (counter = 0; counter < arrayLength;counter++) deltaSum += this.deltaArray[counter];
 this.averageDelta = (deltaSum/arrayLength)*100; // work out an averageDelta - a value of 1 equates to a framerate of 100fps, a value of 4 a framerate of 25fps
 if(this.loggingEnabled) log(this.name,"this.averageDelta:" +this.averageDelta);
 removeFrameCallback(this.frameRateCheckCallback);
 delete this.frameRateCheckCallback;
 delete this.deltaArray;
 this.nextJump(); // start jump
}
// called by timer every 0.25 seconds if part way through jump chain. Next jump only starts once !clock.isAdjusting returns false. This is to avoid issues with memory spiking and to allow other OXP scripts time to do their stuff.
this.startnextJump = function()
{
	if(!this.removeCheck) {this.removeCheck = true;this.removeEntities();}
	if(!clock.isAdjusting && timeAccelerationFactor > 1 && this.dynamicTAF) {timeAccelerationFactor = 1;return;} // on first iteration when clock.isAdjusting is false switch TAF back to 1 (will be 16 from previous jump)
	if(!clock.isAdjusting) { // on second iteration when clock.isAdjusting is false start next jump;
		this.jumpTimer.stop();
		delete this.jumpTimer;
		delete this.removeCheck;
		this.jumpFailed = 1;
		this.nextJump();
	}
}
// this function actually starts the jump
this.nextJump = function()
{
	if(this.jumpFailed >= 15) { // if either the jumpEntity fails to create a wormhole or the player collision with the wormhole is not successful and there have been 15 re-tries quit as a bad job.
	log(this.name,"Jump chain failure. Long range jump aborted.");
	player.consoleMessage("Jump chain failure. Long range jump aborted.",6);
	delete this.jumpArray;
	delete this.jumpCounter;
	delete this.jumping;
	delete this.unreachableJumpChain;
	delete this.misjumpCounter;
	delete this.abortJump;
	return;
	}
	var spawnDistance = Math.sqrt(player.ship.mass * 0.1)+((65+(player.ship.speed/8.75))*this.averageDelta*this.jumpFailed); // this sets the distance in front of the player ship the jumpEntity will spawn. (player.ship.mass * 0.1) is the distance beyond which the player ship will not masslock the jump. ((65+(player.ship.speed/8.75))*this.averageDelta*this.jumpFailed) is a buffer based on the speed of the ship, the frame rate and whether or not a previous attempt failed. The faster the ship is moving, the slower the framerate, or previous failures will result in the entity being spawned further ahead of the player.
	var nextdest;
	// the jump chain is actually a series of misjumps - if the next system is the jumpArray is <= 7 lightyears set it as destination and misjump - if it is > 7 lightyears retain last jump target system and misjump a bit closer. As the jumpArray is optimised by time at some point the next system should always be within range, I think!!! ;-)
	if(this.loggingEnabled) log(this.name,"Distance to next system in jumpArray:"+ System.infoForSystem(galaxyNumber,system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter])));
	if(System.infoForSystem(galaxyNumber,system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,this.jumpArray[this.jumpCounter])) <= 7) {nextdest = this.jumpArray[this.jumpCounter];this.jumpCounter++;this.jumpCounterInc = true;}
	else nextdest = this.jumpArray[(this.jumpCounter - 1)];
	if(this.loggingEnabled) log(this.name,"Jump destination: "+ nextdest);
	if(this.jumpCounter < this.jumpArray.length) player.ship.scriptedMisjump = true; // misjump unless last jump in chain.
	this.playerOrientation = player.ship.orientation;
	this.lockPlayerOrientation = addFrameCallback(this.lockPlayerOrientationFunction.bind(this));
	this.jumpEntity = system.addShips("alloy",1,player.ship.position.add(player.ship.heading.multiply(spawnDistance)),0)[0]; // spawn jumpEntity in front of player - was "murphy_jump_entity"
	this.jumpEntity.fuel = 7; // ensure jumpEntity has full tank
	var jumpsuccess = this.jumpEntity.exitSystem(nextdest); // and create wormhole
	if(this.loggingEnabled) log(this.name,"Jump success: "+ jumpsuccess);
	if(!jumpsuccess) { // if jump failed try again after incrementing jumpFailed flag. This will result in the jumpEntity spawning further ahead of the player and a reduced velocity boost.
	if(this.jumpCounterInc){this.jumpCounter--; delete this.jumpCounterInc;}
	this.jumpEntity.remove(true);
	this.jumpFailed++;
	this.nextJump();
	return;
	}
	this.jumpEntity.switchAI("missileAI.plist");
	this.jumpEntity.AIState ="EXPLODE";
	this.jumpEntity.remove(true);
//player.ship.velocity = player.ship.velocity.add(player.ship.heading.multiply(((100000/(player.ship.speed+50))/this.averageDelta)/this.jumpFailed)); // give the player ship a velocity boost to force it into the wormhole. Level of boost based on player.ship.speed, framerate and whether previous jump failed. Higher speed, slower framrate, or previous failure will result in a reduced velocity boost.
//this.checkPlayerJumpTimer = new Timer (this,this.checkPlayerJump,1); // timer set for 1 second to see if player has entered wormhole
}

this.lockPlayerOrientationFunction = function()
{
	if(this.playerJumpSuccess || !this.jumping) {
	removeFrameCallback(this.lockPlayerOrientation);
	delete this.lockPlayerOrientation;
	return;
	}
	player.ship.orientation = this.playerOrientation;
}

this.checkPlayerJump = function()
{
 if(this.playerJumpSuccess) return; // this is set under this.shipWillEnterWitchspace
 if(this.loggingEnabled) log(this.name,"Player missed wormhole - respawning JumpEntity."); // Player missed wormhole suggests problem with slow framerate or too high a velocity causing wormhole collision to be missed. Retry after incrementing jumpFailed flag will result in jumpEntity being spawned further in front of ship and a reduced velocity boost.
 if(this.jumpCounterInc){this.jumpCounter--; delete this.jumpCounterInc;}
 this.jumpFailed++;
 this.nextJump();
}

this.removeEntities = function()
{
	var toRemove = system.filteredEntities(this, function (entity){return (entity.isShip && !entity.isPlayer)}, player.ship,(player.ship.scannerRange*2)); // remove all other entities within scannerRange x 2 to avoid mass locking jump
	if(toRemove.length > 0) {
	var arrayLength = toRemove.length;
	var counter;
	for (counter = 0; counter < arrayLength;counter++) toRemove[counter].remove(true);
	}
}

this.timeCheck = function()
{
 if(!clock.isAdjusting) {
		this.timeCheckTimer.stop();
		delete this.timeCheckTimer;
		var timeTaken = Number(((clock.seconds-this.startTime)/3600).toFixed(1));
		if(this.expectedTime !== "Route not possible by normal jumps.") this.expectedTime = Number(this.expectedTime.toFixed(1));
		if(this.loggingEnabled) log(this.name,"Expected time (Normal Jumps) "+this.method+": "+this.expectedTime+" Actual time (misjumps): "+ timeTaken);
		player.consoleMessage("Best Time (Quirium Drive): "+ this.expectedTime +" Actual Time (Thargoid Witchspace Drive): "+ timeTaken +".",6);
		delete this.startTime;
		delete this.expectedTime;
	}
}